//=============================================================================
// WorkBenchMenuMain
//=============================================================================

class WorkBenchMenuRepairPart expands MenuUIWindow;

//Universals
var DeusExPlayer Player;
var PartsBag Bench;
var MSMassEffectMutator Mutator;

//Window Specifics
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var ColorButtonForward NextPart;
var ColorButtonBackward PrevPart;

var CraftingPart CurPart;

var Window PartDisplay, ScrapDisplay;

var ModifiedPersonaTextWindow Durability, Price;

var ModifiedPersonaTextWindow  StatDisplay, ScrapText;
var MenuUIEditWindow CustomNameField;

var int CurPartNum, MaxPartNum;
var class<CraftingPart> PartIndex[50];
var int YOffs[50];
var int XOffs[50];
var int XSize[50];
var int YSize[50];

var PersonaActionButtonWindow RepairButton;

var Window Last;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 return false;
}

event InitWindow()
{
 local int i, j;

	Super.InitWindow();
        SetTitle("Individual Part Repair");
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
	
	CreateOverlays();
	CreateButtons();
        CreateDurabilities();
	CreateTextDisplay();

	CustomNameField = CreateMenuEditWindow(347, 272, 132, 24, winClient);
	CustomNameField.SetText("");
}

function CreateTextDisplay()
{
 StatDisplay = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 StatDisplay.SetPos(16, 268);
 StatDisplay.SetSize(240, 96);
 StatDisplay.SetFont(Font'FontMenuHeaders');

 ScrapText = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 ScrapText.SetPos(96, 32);
 ScrapText.SetSize(96, 96);
 ScrapText.SetFont(Font'FontMenuHeaders');

 ScrapDisplay.SetBackground(Texture'ScrapMetalWB');
}

function CreateDurabilities()
{
 Durability = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durability.SetPos(256, 128);
 Durability.SetSize(96, 20);
 Durability.SetFont(Font'FontMenuHeaders');

 Price = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Price.SetPos(256, 196);
 Price.SetSize(96, 20);
 Price.SetFont(Font'FontMenuHeaders');
}

function CreateButtons()
{
 	NextPart = ColorButtonForward(NewChild(Class'ColorButtonForward'));
	NextPart.SetPos(490, 288);

 	PrevPart = ColorButtonBackward(NewChild(Class'ColorButtonBackward'));
	PrevPart.SetPos(324, 288);
		
	RepairButton = PersonaActionButtonWindow(NewChild(Class'PersonaActionButtonWindow'));
	RepairButton.SetPos(432, 368);
	RepairButton.SetButtonText("|p4Repair for |cf88000ERR");
}

function CreateOverlays()
{	
	PartDisplay = NewChild(Class'Window');
	SetupOverlay(PartDisplay, 0, 0, 256, 256);

	ScrapDisplay = NewChild(Class'Window');
	SetupOverlay(ScrapDisplay, 32, 32, 64, 64);
}

function SetupOverlay(Window Win, int PosX, int PosY, int WidthX, int HeightY)
{
	win.SetBackgroundStyle(DSTY_Masked);
	win.SetPos(PosX, PosY);
	win.SetSize(WidthX, HeightY);
}

function UpdateIcons()
{
 if (CurPart == None || CurPart.bDeleteMe) PartDisplay.SetBackground(None);
 if (CurPart != None && !CurPart.bDeleteMe)
 {
  CurPartNum = GetPartEquivalent();
  
  SetupOverlay(PartDisplay, XOffs[CurPartNum], YOffs[CurPartNum], XSize[CurPartNum], YSize[CurPartNum]);
  PartDisplay.SetBackground(CurPart.BenchIcon);
 }
 
 if (CurPart.CurDurability >= CurPart.Durability) RepairButton.SetSensitivity(False);
 if (CurPart.CurDurability < CurPart.Durability) RepairButton.SetSensitivity(True);
 
 UpdateStats();
}

function int GetPartEquivalent()
{
 local int i;
 
 for(i=0; i<MaxPartNum + 1; i++)
 {
  if (CurPart.Class == PartIndex[i])
  {
   return i;
  }
 }
 
 return 0;
}

function UpdateStats()
{
 //StatDisplay.SetText(TempSpawnStats()$CR()$"|p4Cost: "$CurPart.Default.Cost);
 StatDisplay.SetText(CurPart.GetStats());
 //if (CurPart == None) StatDisplay.SetText("");
 
 RepairButton.SetButtonText("|p4Repair");
 
 if (CurPart != None && !CurPart.bDeleteMe)
 {
  Price.SetText("|p4Repair for "$GetRepairCost());
  Durability.SetText(CurPart.CurDurability);
  CustomNameField.SetText(CurPart.ItemName);
 }
 
 if (CurPart == None || CurPart.bDeleteMe)
 {
  Price.SetText("");
  Durability.SetText("");
  CustomNameField.SetText("");
 }
 
 ScrapText.SetText(String(Mutator.CurScrap));
}

simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function int GetRepairCost()
{
 local float RefundF;
 local int Refund;
 
 if (CurPart.Durability > 0) RefundF = (float(CurPart.Durability) - CurPart.CurDurability) / CurPart.Durability * CurPart.Cost;
 Refund = RefundF;

 if (CurPart.Durability <= 0) Refund = CurPart.Cost;
 
 //if (Refund <= 0) Refund = 1;
 
 return Refund;
}

function RepairPart()
{
 local CraftingPart C;
 local int Refund;
 
 if (CurPart == None || CurPart.CurDurability >= CurPart.Durability)
 {
  Bench.PlaySound(Sound'InsufficientScrap');
  return;
 }
 
 Refund = GetRepairCost();
 
 if (Mutator.CurScrap < Refund)
 {
  Bench.PlaySound(Sound'InsufficientScrap');
  return;
 }
 
 Mutator.CurScrap -= Refund;
 
 CurPart.CurDurability = CurPart.Durability;

 Bench.PlaySound(Sound'BreakdownPart');
 
 //ForwardPart();
 
 UpdateIcons();
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		case exitButton:

			Last.Show(True);

			root.PopWindow();
			bHandled = True;
			break;

		case NextPart:
			BackwardPart();
			bHandled = True;
			break;
		case PrevPart:
			ForwardPart();
			bHandled = True;
			break;

		case RepairButton:
			RepairPart();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	/*if (ButtonPressed != exitButton)
	{
		UpdateInfo();
	}*/

	return bHandled;
}

//==================================================
//++++++++++++++++++++++++++++++++++++++++++++++++++
//NEXT PART FUNCTIONS BEGIN
//++++++++++++++++++++++++++++++++++++++++++++++++++
//==================================================

function ForwardPart()
{
 local CraftingPart P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'CraftingPart', P)
 {
  if (P.Owner == Player && P.Durability > 0)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurPart == None || CurPart.bDeleteMe)
   {
    Pick = First;
    break;
   }
   
   if (P == CurPart) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurPart = Pick;
 UpdateIcons();
}

function BackwardPart()
{
 local CraftingPart P, Pick, First, Last;
 
 forEach Player.AllActors(class'CraftingPart', P)
 {
  if (P.Owner == Player && P.Durability > 0)
  {
   if (First == None) First = P;
   
   if (P == CurPart && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurPart == None || CurPart.bDeleteMe || Pick == None)
 {
  Pick = Last;
 }

 CurPart = Pick;
 UpdateIcons();
}

//==================================================
//--------------------------------------------------
//PREV PART FUNCTIONS END
//--------------------------------------------------
//==================================================


defaultproperties
{

     Title="Individual Part Repair"
     exitButtonText="Done"
     ClientWidth=512
     ClientHeight=384

     clientTextures(0)=Texture'WorkBenchRifleBG1'
     clientTextures(1)=Texture'WorkBenchRifleBG2'
     clientTextures(2)=Texture'WorkBenchRifleBG3'
     clientTextures(3)=Texture'WorkBenchRifleBG4'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=2
     MaxPartNum=34
     CurPartNum=0

     PartIndex(0)=class'FoldingStock'
     YOffs(0)=23
     XOffs(0)=190
     XSize(0)=256
     YSize(0)=256
     PartIndex(1)=class'CollapsibleStock'
     YOffs(1)=23
     XOffs(1)=190
     XSize(1)=256
     YSize(1)=256
     PartIndex(2)=class'WoodStock'
     YOffs(2)=23
     XOffs(2)=190
     XSize(2)=256
     YSize(2)=256
     PartIndex(3)=class'M16Stock'
     YOffs(3)=23
     XOffs(3)=190
     XSize(3)=256
     YSize(3)=256
     PartIndex(4)=class'CarbonFiberBody'
     YOffs(4)=107
     XOffs(4)=197
     XSize(4)=256
     YSize(4)=128
     PartIndex(5)=class'IronBody'
     YOffs(5)=107
     XOffs(5)=197
     XSize(5)=256
     YSize(5)=128
     PartIndex(6)=class'SteelBody'
     YOffs(6)=107
     XOffs(6)=197
     XSize(6)=256
     YSize(6)=128
     PartIndex(7)=class'TitaniumBody'
     YOffs(7)=107
     XOffs(7)=197
     XSize(7)=256
     YSize(7)=128
     PartIndex(8)=class'Mag10Shot'
     YOffs(8)=117
     XOffs(8)=245
     XSize(8)=128
     YSize(8)=128
     PartIndex(9)=class'Mag20Shot'
     YOffs(9)=117
     XOffs(9)=245
     XSize(9)=128
     YSize(9)=128
     PartIndex(10)=class'Mag30Shot'
     YOffs(10)=117
     XOffs(10)=245
     XSize(10)=128
     YSize(10)=128
     PartIndex(11)=class'Mag100Shot'
     YOffs(11)=117
     XOffs(11)=245
     XSize(11)=128
     YSize(11)=128
     PartIndex(12)=class'SemiFirePin'
     YOffs(12)=44
     XOffs(12)=83
     XSize(12)=256
     YSize(12)=128
     PartIndex(13)=class'SemiBurstFirePin'
     YOffs(13)=44
     XOffs(13)=83
     XSize(13)=256
     YSize(13)=128
     PartIndex(14)=class'SemiAutoFirePin'
     YOffs(14)=44
     XOffs(14)=83
     XSize(14)=256
     YSize(14)=128
     PartIndex(15)=class'M16Barrel'
     YOffs(15)=51
     XOffs(15)=190
     XSize(15)=256
     YSize(15)=256
     PartIndex(16)=class'AK47Barrel'
     YOffs(16)=51
     XOffs(16)=190
     XSize(16)=256
     YSize(16)=256
     PartIndex(17)=class'G3Barrel'
     YOffs(17)=51
     XOffs(17)=190
     XSize(17)=256
     YSize(17)=256
     PartIndex(18)=class'M60Barrel'
     YOffs(18)=51
     XOffs(18)=190
     XSize(18)=256
     YSize(18)=256
     PartIndex(19)=class'GunPowder'
     YOffs(19)=-90
     XOffs(19)=119
     XSize(19)=256
     YSize(19)=256
     PartIndex(20)=class'IncindiaryPowder'
     YOffs(20)=-90
     XOffs(20)=119
     XSize(20)=256
     YSize(20)=256
     PartIndex(21)=class'ExplosivePowder'
     YOffs(21)=-90
     XOffs(21)=119
     XSize(21)=256
     YSize(21)=256
     PartIndex(22)=class'EMPPowder'
     YOffs(22)=-90
     XOffs(22)=119
     XSize(22)=256
     YSize(22)=256
     PartIndex(23)=class'RifleCasing556'
     YOffs(23)=2
     XOffs(23)=123
     XSize(23)=256
     YSize(23)=256
     PartIndex(24)=class'RifleCasing762'
     YOffs(24)=2
     XOffs(24)=123
     XSize(24)=256
     YSize(24)=256
     PartIndex(25)=class'RifleCasing50'
     YOffs(25)=2
     XOffs(25)=123
     XSize(25)=256
     YSize(25)=256
     PartIndex(26)=class'StandardRifleTipping'
     YOffs(26)=100
     XOffs(26)=121
     XSize(26)=256
     YSize(26)=64
     PartIndex(27)=class'HPRifleTipping'
     YOffs(27)=100
     XOffs(27)=121
     XSize(27)=256
     YSize(27)=64
     PartIndex(28)=class'APRifleTipping'
     YOffs(28)=100
     XOffs(28)=121
     XSize(28)=256
     YSize(28)=64
     PartIndex(29)=class'VenomRifleTipping'
     YOffs(29)=100
     XOffs(29)=121
     XSize(29)=256
     YSize(29)=64
     PartIndex(30)=class'AcogSight'
     YOffs(30)=100
     XOffs(30)=249
     XSize(30)=64
     YSize(30)=64
     PartIndex(31)=class'GrenadeLauncher'
     YOffs(31)=100
     XOffs(31)=249
     XSize(31)=64
     YSize(31)=64
     PartIndex(32)=class'LaserSight'
     YOffs(32)=100
     XOffs(32)=249
     XSize(32)=64
     YSize(32)=64
     PartIndex(33)=class'Silencer'
     YOffs(33)=100
     XOffs(33)=249
     XSize(33)=64
     YSize(33)=64
     PartIndex(34)=class'Flashlight'
     YOffs(34)=100
     XOffs(34)=249
     XSize(34)=64
     YSize(34)=64
}
